<?php
declare(strict_types=1);

/**
 * فایل تنظیمات اصلی پروژه.
 * لطفاً قبل از استقرار، مقادیر را با اطلاعات واقعی هاست و ربات جایگزین کن.
 */

return [
    // تنظیمات کلی برنامه برای ثبت گزارش‌ها و منطقه زمانی.
    'app' => [
        'timezone' => 'Asia/Tehran',
        'log_file' => __DIR__ . '/bot.log',
        'php_binary' => getenv('PHP_BINARY_PATH') ?: (PHP_SAPI === 'cli' ? PHP_BINARY : '/usr/bin/php'),
    ],

    // اتصال به دیتابیس MySQL در هاستینگر. مقادیر را از محیط یا به صورت دستی پر کن.
    'database' => (function (): array {
        $host = getenv('DB_HOST') ?: 'localhost';
        $name = getenv('DB_NAME') ?: 'u667850630_bot';
        $user = getenv('DB_USERNAME') ?: 'u667850630_bot';
        $pass = getenv('DB_PASSWORD') ?: 'u/mSvQ$Ex8';

        return [
            'dsn' => sprintf('mysql:host=%s;dbname=%s;charset=utf8mb4', $host, $name),
            'username' => $user,
            'password' => $pass,
            'options' => [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
            ],
        ];
    })(),

    // اطلاعات ربات برای مدیریت کاربران و ادمین‌ها داخل خود تلگرام.
    'telegram' => [
        'bot_token' => getenv('BOT_TOKEN') ?: '6211603525:AAHDWwD8cKklj_2uAsUjUyVPvm2qjBpSygs',
        'bot_username' => getenv('BOT_USERNAME') ?: 'remfefoegmrgbot',
        'sudo_ids' => array_filter(array_map('intval', explode(',', getenv('BOT_SUDO_IDS') ?: '5529726664,7028958157'))),
        'admin_group_id' => (int) (getenv('BOT_ADMIN_GROUP') ?: -1001741571706),
        'webhook_secret' => '',
    ],
];


