<?php
declare(strict_types=1);

/**
 * اسکریپت ساده برای ساخت جداول دیتابیس.
 * این فایل را یک بار در مرورگر باز کن تا همه‌ی جدول‌ها ایجاد شوند.
 */

require __DIR__ . '/config.php';
require __DIR__ . '/database.php';

$config = require __DIR__ . '/config.php';
$pdo = Database::pdo($config['database']);

$schemaPath = __DIR__ . '/schema.sql';
if (!file_exists($schemaPath)) {
    http_response_code(500);
    exit('schema.sql پیدا نشد');
}

$schemaSql = file_get_contents($schemaPath);

try {
    $pdo->exec($schemaSql);
} catch (Throwable $exception) {
    http_response_code(500);
    exit('اجرای اسکیما با خطا مواجه شد: ' . $exception->getMessage());
}

echo 'جداول با موفقیت ساخته شدند ✔️';


